*************************************************************************
*                                                                       *
* UltraChat Application Program Interface Module (API)                  *
*                                                                       *
*    Revision 1.00 - 03/15/94 by Robert C. Hartman                      *
*                                                                       *
*    This TDBS module can be used to seemlessly link TDBS programs with *
*    UltraChat.  It provides all of the calls necessary to utilize      *
*    UltraChat functionality within a TDBS program to an extent that    *
*    programs can be written which appear to be running "inside" chat   *
*    instead of external to it.                                         *
*                                                                       *
*************************************************************************
*
*************************************************************************
*                                                                       *
* UC_RECV - receive any data from UltraChat                             *
*                                                                       *
*    If there is data to be received from UltraChat, this routine will  *
*    get it.  It takes one string parameter, which is the OptData to    *
*    send to UltraChat.  A /Q will be appended to it before the call.   *
*                                                                       *
*************************************************************************
*
PROCEDURE UC_RECV
PARAMETERS UC_DATA

   UC_A = ULPEEK (246, 1)               && Get flags byte
   IF (UC_A .AND. 16) = 16              && Do we have something to print?
      DO UC_CALL WITH UC_DATA+" /Q"     && Yes, so print it out
   ENDIF

   RETURN

*
*************************************************************************
*                                                                       *
* UC_SEND - send a string to UltraChat for processing                   *
*                                                                       *
*    Takes two string parameters - the first is the string which gets   *
*    passed to UltraChat as input.  The second is the UltraChat call    *
*    which will have a /FI:<filename> appended to it before the call.   *
*    This routine uses SET ALTERNATE TO, so the application program     *
*    must make sure that it has no active SET ALTERNATE TO, or that it  *
*    knows how to get it restarted.  This routine also shuts off the    *
*    console when it sends the string to UltraChat.                     *
*                                                                       *
*************************************************************************
*
PROCEDURE UC_SEND
PARAMETERS UC_DATA, UC_OP

   UC_TMP = "UCTMP."+ULINE()            && Create a temporary filename
   SET ALTERNATE TO "UCTMP."+ULINE()    && Make a temporary file
   SET ALTERNATE ON                     && Turn alternate file on
   SET CONSOLE OFF                      && Turn off the console

   ?? UC_DATA+CHR(13)                   && Output the data needed

   SET CONSOLE ON                       && Turn console back on
   SET ALTERNATE OFF                    && Turn alternate file off
   SET ALTERNATE TO                     && Make sure it is closed

   UC_TMP = UC_OP+" /FI:"+UC_TMP        && Set up call for UltraChat
   DO UC_CALL WITH UC_TMP               && Do it

   RETURN                               && This won't ever happen

*
*************************************************************************
*                                                                       *
* UC_CALL - call UltraChat                                              *
*                                                                       *
*    Takes one string parameter which is passed as the OptData to       *
*    UltraChat.  This routine does NOT return, and any ON DISCONNECT    *
*    will be called before exiting to UltraChat.  To avoid screen clear *
*    codes being sent, this routine turns the user into a non-ANSI      *
*    user with a clear screen code of space, backspace.  This works on  *
*    remote terminals, but NOT on the console, since TBBS knows enough  *
*    about the console to use true VT-100 screen clear codes when the   *
*    user has ANSI set.  It is recommended that the OptData passed to   *
*    UltraChat include a /S:200,"optdata" which will return control     *
*    to the calling program so that a call to UC_RET can be made to     *
*    return the user to their normal state.                             *
*                                                                       *
*************************************************************************
*
PROCEDURE UC_CALL
PARAMETERS UC_DATA                      && UltraChat Optdata

   IF UANSI ()
      UC_A = ULREPLACE(UANSI, .F.)      && Turn off ANSI

      UC_A = ULPEEK (246, 1)            && Get the flags byte
      IF (UC_A .AND. 32) <> 32          && If we haven't already done this
         UC_A = UC_A .OR. 32            && Set the bit
         UC_A = ULPOKE (246, 1, UC_A)   && Put back the new value
         UC_A = ULPEEK (64, 2)          && Get first CLS word
         UC_A = ULPOKE (443, 2, UC_A)   && Store it here
         UC_A = ULPEEK (66, 1)          && Get third CLS byte
         UC_A = ULPOKE (445, 1, UC_A)   && Store it here
         UC_A = ULPOKE (64, 1, 32)      && space
         UC_A = ULPOKE (65, 1, 8)       && backspace
         UC_A = ULPOKE (66, 1, 0)       && null
      ENDIF
   ENDIF

   DOTBBS TYPE 203 OPTDATA "/T "+UC_DATA        && Do the call (we won't return!)

   RETURN                               && won't happen

*
*************************************************************************
*                                                                       *
* UC_RET - return from UltraChat                                        *
*                                                                       *
*    Called when a program returns from a UC_CALL.  This is necessary   *
*    to put the user back into their normal state as far as ANSI and    *
*    clear screen codes.                                                *
*                                                                       *
*************************************************************************
*
PROCEDURE UC_RET
   UC_A = ULPEEK (246, 1)               && Get the flags byte

   IF (UC_A .AND. 32) = 32              && If we have the bit set
      UC_A = UC_A .AND. (255 - 32)      && Clear the bit
      UC_A = ULPOKE (246, 1, UC_A)      && Put the corrected flag back
      UC_A = ULPEEK (443, 2)            && Get the CLS first word
      UC_A = ULPOKE (64, 2, UC_A)       && Put back the CLS code
      UC_A = ULPEEK (445, 1)            && Get the CLS third byte
      UC_A = ULPOKE (66, 1, UC_A)       && Put back the CLS code
      UC_A = ULPOKE (443, 2, 0)         && Clear this out again
      UC_A = ULPOKE (445, 1, 0)         && Clear this out again
      UC_A = ULREPLACE(UANSI, .T.)      && Turn on ANSI again
   ENDIF

   ERASE "UCTMP."+ULINE()               && Kill any file we generated

   RETURN                               && Back to caller
